/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.mib;

import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.mib.MibCounter;
import ibm.nways.jdm.mib.MibGauge;
import ibm.nways.jdm.mib.MibIPAddress;
import ibm.nways.jdm.mib.MibImport;
import ibm.nways.jdm.mib.MibInteger;
import ibm.nways.jdm.mib.MibLongCounter;
import ibm.nways.jdm.mib.MibModule;
import ibm.nways.jdm.mib.MibOITreeNode;
import ibm.nways.jdm.mib.MibObject;
import ibm.nways.jdm.mib.MibObjectIdentifier;
import ibm.nways.jdm.mib.MibObjectIdentifierValue;
import ibm.nways.jdm.mib.MibOctetString;
import ibm.nways.jdm.mib.MibRangeSubtype;
import ibm.nways.jdm.mib.MibTimeTicks;
import ibm.nways.jdm.mib.MibTrap;
import ibm.nways.jdm.mib.MibType;
import ibm.nways.jdm.mib.MibValue;
import java.util.Enumeration;
import java.util.Hashtable;

public class MibMetadata {
    protected Hashtable modules = new Hashtable();
    public Hashtable ois = new Hashtable();
    public boolean allResolved = false;
    private boolean debug = false;
    private OITreeNode root = new OITreeNode();
    private OITreeNode ccittBranch;
    private OITreeNode isoBranch;
    private OITreeNode jointBranch;
    private boolean traceimports = false;
    private boolean resolved = true;

    public MibMetadata() {
        this.root.children = new Hashtable();
        this.root.oi = new MibObjectIdentifierValue(null, "", "");
        this.ccittBranch = new OITreeNode();
        this.ccittBranch.children = new Hashtable();
        this.ccittBranch.oi = new MibObjectIdentifierValue(null, "ccitt", "0");
        this.ccittBranch.lastComponent = 0;
        this.isoBranch = new OITreeNode();
        this.isoBranch.children = new Hashtable();
        this.isoBranch.oi = new MibObjectIdentifierValue(null, "iso", "1");
        this.isoBranch.lastComponent = 1;
        this.jointBranch = new OITreeNode();
        this.jointBranch.children = new Hashtable();
        this.jointBranch.oi = new MibObjectIdentifierValue(null, "joint-iso-ccitt", "2");
        this.jointBranch.lastComponent = 2;
        this.root.children.put(new Integer(0), this.ccittBranch);
        this.root.children.put(new Integer(1), this.isoBranch);
        this.root.children.put(new Integer(2), this.jointBranch);
        MibRangeSubtype mibRangeSubtype = new MibRangeSubtype();
        MibRangeSubtype mibRangeSubtype2 = new MibRangeSubtype();
        MibRangeSubtype mibRangeSubtype3 = new MibRangeSubtype();
        MibRangeSubtype mibRangeSubtype4 = new MibRangeSubtype();
        MibRangeSubtype mibRangeSubtype5 = new MibRangeSubtype();
        mibRangeSubtype.addRange((long)Integer.MIN_VALUE, (long)Integer.MAX_VALUE);
        mibRangeSubtype2.addRange(Long.MIN_VALUE, Long.MAX_VALUE);
        mibRangeSubtype3.addRange(0L, Integer.MAX_VALUE);
        mibRangeSubtype4.addRange(0L, Long.MAX_VALUE);
        mibRangeSubtype5.addRange(4L, 4L);
        MibModule mibModule = new MibModule(this);
        mibModule.name = "RFC1155-SMI";
        mibModule.id = "";
        mibModule.putValue("internet", new MibObjectIdentifierValue(mibModule, "internet", "1.3.6.1"));
        mibModule.putValue("directory", new MibObjectIdentifierValue(mibModule, "directory", "1.3.6.1.1"));
        mibModule.putValue("mgmt", new MibObjectIdentifierValue(mibModule, "mgmt", "1.3.6.1.2"));
        mibModule.putValue("experimental", new MibObjectIdentifierValue(mibModule, "experimental", "1.3.6.1.3"));
        mibModule.putValue("private", new MibObjectIdentifierValue(mibModule, "private", "1.3.6.1.4"));
        mibModule.putValue("enterprises", new MibObjectIdentifierValue(mibModule, "enterprises", "1.3.6.1.4.1"));
        mibModule.putType("ObjectName", new MibObjectIdentifier(mibModule, "ObjectName"));
        mibModule.putType("NetworkAddress", new MibIPAddress(mibModule, "NetworkAddress"));
        mibModule.putType("IpAddress", new MibOctetString(mibModule, "IpAddress", mibRangeSubtype5));
        mibModule.putType("Counter", new MibInteger(mibModule, "Counter", mibRangeSubtype3));
        mibModule.putType("Gauge", new MibInteger(mibModule, "Gauge", mibRangeSubtype3));
        mibModule.putType("TimeTicks", new MibInteger(mibModule, "TimeTicks", mibRangeSubtype3));
        mibModule.putType("Opaque", new MibOctetString(mibModule, "Opaque"));
        this.modules.put(mibModule.name, mibModule);
        MibModule mibModule2 = new MibModule(this);
        mibModule2.name = "RFC1158-MIB";
        mibModule2.id = "";
        mibModule2.putValue("mib-2", new MibObjectIdentifierValue(mibModule2, "mib-2", "1.3.6.1.2.1"));
        mibModule2.putValue("system", new MibObjectIdentifierValue(mibModule2, "system", "1.3.6.1.2.1.1"));
        mibModule2.putValue("interfaces", new MibObjectIdentifierValue(mibModule2, "interfaces", "1.3.6.1.2.1.2"));
        mibModule2.putValue("at", new MibObjectIdentifierValue(mibModule2, "at", "1.3.6.1.2.1.3"));
        mibModule2.putValue("ip", new MibObjectIdentifierValue(mibModule2, "ip", "1.3.6.1.2.1.4"));
        mibModule2.putValue("icmp", new MibObjectIdentifierValue(mibModule2, "icmp", "1.3.6.1.2.1.5"));
        mibModule2.putValue("tcp", new MibObjectIdentifierValue(mibModule2, "tcp", "1.3.6.1.2.1.6"));
        mibModule2.putValue("udp", new MibObjectIdentifierValue(mibModule2, "udp", "1.3.6.1.2.1.7"));
        mibModule2.putValue("egp", new MibObjectIdentifierValue(mibModule2, "egp", "1.3.6.1.2.1.8"));
        mibModule2.putValue("cmot", new MibObjectIdentifierValue(mibModule2, "cmot", "1.3.6.1.2.1.9"));
        mibModule2.putValue("transmission", new MibObjectIdentifierValue(mibModule2, "transmission", "1.3.6.1.2.1.10"));
        mibModule2.putValue("snmp", new MibObjectIdentifierValue(mibModule2, "snmp", "1.3.6.1.2.1.11"));
        this.modules.put(mibModule2.name, mibModule2);
        MibModule mibModule3 = new MibModule(this);
        mibModule3.name = "SNMPv2-SMI";
        mibModule3.putValue("org", new MibObjectIdentifierValue(mibModule3, "org", "1.3"));
        mibModule3.putValue("dod", new MibObjectIdentifierValue(mibModule3, "dod", "1.3.6"));
        mibModule3.putValue("internet", new MibObjectIdentifierValue(mibModule3, "internet", "1.3.6.1"));
        mibModule3.putValue("directory", new MibObjectIdentifierValue(mibModule3, "directory", "1.3.6.1.1"));
        mibModule3.putValue("mgmt", new MibObjectIdentifierValue(mibModule3, "mgmt", "1.3.6.1.2"));
        mibModule3.putValue("mib-2", new MibObjectIdentifierValue(mibModule3, "mib-2", "1.3.6.1.2.1"));
        mibModule3.putValue("transmission", new MibObjectIdentifierValue(mibModule3, "transmission", "1.3.6.1.2.1.10"));
        mibModule3.putValue("experimental", new MibObjectIdentifierValue(mibModule3, "experimental", "1.3.6.1.3"));
        mibModule3.putValue("private", new MibObjectIdentifierValue(mibModule3, "private", "1.3.6.1.4"));
        mibModule3.putValue("enterprises", new MibObjectIdentifierValue(mibModule3, "enterprises", "1.3.6.1.4.1"));
        mibModule3.putValue("security", new MibObjectIdentifierValue(mibModule3, "security", "1.3.6.1.5"));
        mibModule3.putValue("snmpV2", new MibObjectIdentifierValue(mibModule3, "security", "1.3.6.1.6"));
        mibModule3.putValue("snmpDomains", new MibObjectIdentifierValue(mibModule3, "snmpDomains", "1.3.6.1.6.1"));
        mibModule3.putValue("snmpProxys", new MibObjectIdentifierValue(mibModule3, "snmpProxys", "1.3.6.1.6.2"));
        mibModule3.putValue("snmpModules", new MibObjectIdentifierValue(mibModule3, "snmpModules", "1.3.6.1.6.3"));
        mibModule3.putType("ObjectName", new MibObjectIdentifier(mibModule3, "ObjectName"));
        mibModule3.putType("NotificationName", new MibObjectIdentifier(mibModule3, "NotificationName"));
        mibModule3.putType("Integer32", new MibInteger(mibModule3, "Integer32", mibRangeSubtype));
        mibModule3.putType("IpAddress", new MibOctetString(mibModule3, "IpAddress", mibRangeSubtype5));
        mibModule3.putType("Counter32", new MibCounter(mibModule3, "Counter32", mibRangeSubtype3));
        mibModule3.putType("Gauge32", new MibGauge(mibModule3, "Gauge32", mibRangeSubtype3));
        mibModule3.putType("Unsigned32", new MibInteger(mibModule3, "Unsigned32", mibRangeSubtype3));
        mibModule3.putType("TimeTicks", new MibTimeTicks(mibModule3, "TimeTicks", mibRangeSubtype3));
        mibModule3.putType("Opaque", new MibOctetString(mibModule3, "Opaque"));
        mibModule3.putType("Counter64", new MibLongCounter(mibModule3, "Counter64", mibRangeSubtype4));
        this.modules.put(mibModule3.name, mibModule3);
        this.modules.put("SNMPv2-SMI-v1", mibModule3);
    }

    public void resolveImports() {
        this.resolved = true;
        try {
            if (this.traceimports) {
                System.err.println("Resolving imports in modules ...");
            }
            Enumeration enumeration = this.modules.elements();
            while (enumeration.hasMoreElements()) {
                MibModule mibModule = (MibModule)enumeration.nextElement();
                if (this.traceimports) {
                    System.out.println("Resolving imports for module: " + mibModule.name);
                }
                Enumeration enumeration2 = mibModule.imports.keys();
                while (enumeration2.hasMoreElements()) {
                    String string = (String)enumeration2.nextElement();
                    MibImport mibImport = (MibImport)mibModule.imports.get(string);
                    if (Character.isLowerCase(mibImport.importName.charAt(0))) {
                        this.resolveImportForValue(mibModule, mibImport);
                        continue;
                    }
                    this.resolveImportForType(mibModule, mibImport);
                }
                mibModule.postprocess();
            }
            if (this.traceimports) {
                System.err.println("Import resolution complete");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.allResolved = this.resolved;
    }

    private MibType resolveImportForType(MibModule mibModule, MibImport mibImport) {
        MibType mibType = null;
        if (this.traceimports) {
            System.out.println("Import: " + mibImport.sourceModuleName + "." + mibImport.importName);
        }
        if (this.modules.containsKey(mibImport.sourceModuleName)) {
            MibModule mibModule2 = (MibModule)this.modules.get(mibImport.sourceModuleName);
            if (this.traceimports) {
                System.out.println("Source module: " + mibModule2.name);
            }
            if ((mibType = mibModule2.getType(mibImport.importName)) != null) {
                mibModule.putType(mibType.name, mibType);
                if (this.traceimports) {
                    System.out.println("    new type " + mibType + " added to module " + mibModule.name + " as " + mibType.name);
                }
            } else {
                MibImport mibImport2 = mibModule2.getImport(mibImport.importName);
                if (mibImport2 != null) {
                    if (this.traceimports) {
                        System.out.println("--- type found in import");
                    }
                    mibType = this.resolveImportForType(mibModule2, mibImport2);
                    mibModule.putType(mibType.name, mibType);
                    if (this.traceimports) {
                        System.out.println("    new type " + mibType + " added to module " + mibModule.name + " as " + mibType.name);
                    }
                } else {
                    System.err.println("Error: Unable to find IMPORT " + mibImport.importName + " in module " + mibImport.sourceModuleName + " as specified in module " + mibModule.name);
                    this.resolved = false;
                }
            }
        } else {
            System.err.println("Error: Unable to find module " + mibImport.sourceModuleName + " needed by IMPORT in module " + mibModule.name);
            this.resolved = false;
        }
        return mibType;
    }

    private MibValue resolveImportForValue(MibModule mibModule, MibImport mibImport) {
        MibValue mibValue = null;
        if (this.traceimports) {
            System.out.println("Import: " + mibImport.sourceModuleName + "." + mibImport.importName);
        }
        if (this.modules.containsKey(mibImport.sourceModuleName)) {
            MibModule mibModule2 = (MibModule)this.modules.get(mibImport.sourceModuleName);
            if (this.traceimports) {
                System.out.println("Source module: " + mibModule2.name);
            }
            if ((mibValue = mibModule2.getValue(mibImport.importName)) != null) {
                mibModule.putValue(mibValue.name, mibValue);
                if (this.traceimports) {
                    System.out.println("    new value " + mibValue + " added to module " + mibModule.name + " as " + mibValue.name);
                }
            } else {
                MibImport mibImport2 = mibModule2.getImport(mibImport.importName);
                if (mibImport2 != null) {
                    if (this.traceimports) {
                        System.out.println("--- value found in import");
                    }
                    mibValue = this.resolveImportForValue(mibModule2, mibImport2);
                    mibModule.putValue(mibValue.name, mibValue);
                    if (this.traceimports) {
                        System.out.println("    new value " + mibValue + " added to module " + mibModule.name + " as " + mibValue.name);
                    }
                } else {
                    System.err.println("Error: Unable to find IMPORT " + mibImport.importName + " in module " + mibImport.sourceModuleName + " as specified in module " + mibModule.name);
                    this.resolved = false;
                }
            }
        } else {
            System.err.println("Error: Unable to find module " + mibImport.sourceModuleName + " needed by IMPORT in module " + mibModule.name);
            this.resolved = false;
        }
        return mibValue;
    }

    public Enumeration getModules() {
        return this.modules.elements();
    }

    public Enumeration getModuleNames() {
        return this.modules.keys();
    }

    public MibModule getModule(String string) {
        return (MibModule)this.modules.get(string);
    }

    public void addModule(MibModule mibModule) {
        this.modules.put(mibModule.name, mibModule);
    }

    public boolean containsModule(String string) {
        return this.modules.containsKey(string);
    }

    public void dump() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            mibModule.dumpImports(System.out);
            mibModule.dumpValues(System.out);
            mibModule.dumpObjects(System.out);
            mibModule.dumpTypes(System.out);
            mibModule.dumpTraps(System.out);
        }
    }

    public void dumpImports() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            mibModule.dumpImports(System.out);
        }
    }

    public void dumpValues() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            mibModule.dumpValues(System.out);
        }
    }

    public void dumpObjects() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            mibModule.dumpObjects(System.out);
        }
    }

    public void dumpTables() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            mibModule.dumpTables(System.out);
        }
    }

    public void dumpTypes() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            mibModule.dumpTypes(System.out);
        }
    }

    public void dumpTraps() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            mibModule.dumpTraps(System.out);
        }
    }

    public void dumpObjTypes() {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            mibModule.dumpObjType(System.out);
        }
    }

    public void dumpTree() {
        this.dumpTree(this.root);
    }

    public void dumpTree(OITreeNode oITreeNode) {
        try {
            if (oITreeNode != null) {
                System.out.println(oITreeNode.toString());
                if (oITreeNode.children != null) {
                    Enumeration enumeration = oITreeNode.children.elements();
                    while (enumeration.hasMoreElements()) {
                        OITreeNode oITreeNode2 = (OITreeNode)enumeration.nextElement();
                        this.dumpTree(oITreeNode2);
                    }
                    return;
                }
            } else {
                System.out.println("null node ...");
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void genSummary() {
        try {
            Object object;
            Hashtable hashtable = new Hashtable();
            Enumeration enumeration = this.modules.elements();
            while (enumeration.hasMoreElements()) {
                object = (MibModule)enumeration.nextElement();
                ((MibModule)object).genSummary(hashtable);
            }
            object = hashtable.elements();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                System.out.println(string);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public MibObject getObject(String string) {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            MibObject mibObject = mibModule.getObject(string);
            if (mibObject == null) continue;
            return mibObject;
        }
        return null;
    }

    public MibValue getValue(String string) {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            MibValue mibValue = mibModule.getValue(string);
            if (mibValue == null) continue;
            return mibValue;
        }
        return null;
    }

    public MibType getType(String string) {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            MibType mibType = mibModule.getType(string);
            if (mibType == null) continue;
            return mibType;
        }
        return null;
    }

    public MibTrap getTrap(String string) {
        Enumeration enumeration = this.modules.elements();
        while (enumeration.hasMoreElements()) {
            MibModule mibModule = (MibModule)enumeration.nextElement();
            MibTrap mibTrap = mibModule.getTrap(string);
            if (mibTrap == null) continue;
            return mibTrap;
        }
        return null;
    }

    public MibObjectIdentifierValue findOI(String string) {
        OITreeNode oITreeNode = null;
        OID oID = new OID(string);
        if (string.length() == 1) {
            if (string.equals("0")) {
                oITreeNode = this.ccittBranch;
            }
            if (string.equals("1")) {
                oITreeNode = this.isoBranch;
            }
            if (string.equals("2")) {
                oITreeNode = this.jointBranch;
            }
        } else {
            oITreeNode = string.charAt(0) == '1' ? this.locateOI(oID, 1, this.isoBranch.children) : (string.charAt(0) == '0' ? this.locateOI(oID, 1, this.ccittBranch.children) : (string.charAt(0) == '2' ? this.locateOI(oID, 1, this.jointBranch.children) : null));
        }
        if (oITreeNode == null) {
            return null;
        }
        return oITreeNode.oi;
    }

    public MibOITreeNode locateOI(String string) {
        OITreeNode oITreeNode = null;
        OID oID = new OID(string);
        if (string.length() == 1) {
            if (string.equals("0")) {
                oITreeNode = this.ccittBranch;
            }
            if (string.equals("1")) {
                oITreeNode = this.isoBranch;
            }
            if (string.equals("2")) {
                oITreeNode = this.jointBranch;
            }
        } else {
            oITreeNode = string.charAt(0) == '1' ? this.locateOI(oID, 1, this.isoBranch.children) : (string.charAt(0) == '0' ? this.locateOI(oID, 1, this.ccittBranch.children) : (string.charAt(0) == '2' ? this.locateOI(oID, 1, this.jointBranch.children) : null));
        }
        if (oITreeNode == null) {
            return null;
        }
        return new MibOITreeNode(oITreeNode);
    }

    private OITreeNode locateOI(OID oID, int n, Hashtable hashtable) {
        OITreeNode oITreeNode;
        OITreeNode oITreeNode2;
        Integer n2 = new Integer(oID.value[n]);
        if (this.debug) {
            System.out.print("  Next component: " + n2 + " children:" + hashtable);
        }
        if ((oITreeNode2 = (OITreeNode)hashtable.get(n2)) == null) {
            if (this.debug) {
                System.out.println(" not found");
            }
            oITreeNode = null;
        } else {
            if (this.debug) {
                System.out.println(" found");
            }
            oITreeNode = n + 1 == oID.value.length ? oITreeNode2 : this.locateOI(oID, n + 1, oITreeNode2.children);
        }
        return oITreeNode;
    }

    public void insertOINode(MibObjectIdentifierValue mibObjectIdentifierValue) {
        try {
            String string = mibObjectIdentifierValue.getValue();
            if (string.length() > 1) {
                if (string.charAt(0) == '0') {
                    this.insertOINode(new OID(mibObjectIdentifierValue.getValue()), 1, mibObjectIdentifierValue, this.ccittBranch.children);
                    return;
                }
                if (string.charAt(0) == '1') {
                    this.insertOINode(new OID(mibObjectIdentifierValue.getValue()), 1, mibObjectIdentifierValue, this.isoBranch.children);
                    return;
                }
                if (string.charAt(0) == '2') {
                    this.insertOINode(new OID(mibObjectIdentifierValue.getValue()), 1, mibObjectIdentifierValue, this.jointBranch.children);
                    return;
                }
                System.err.println("Error: Encountered OBJECT IDENTIFIER " + mibObjectIdentifierValue.toString() + " that does not start with 0, 1, or 2");
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println("Error processing OI: " + mibObjectIdentifierValue.getValue());
        }
    }

    public void insertOINode(OID oID, int n, MibObjectIdentifierValue mibObjectIdentifierValue, Hashtable hashtable) {
        try {
            Integer n2 = new Integer(oID.value[n]);
            OITreeNode oITreeNode = (OITreeNode)hashtable.get(n2);
            if (this.debug) {
                System.out.println("InsertOINode: component = " + n2 + " node = " + oITreeNode);
            }
            if (oITreeNode == null) {
                if (this.debug) {
                    System.out.println("InsertOINode: adding new tree node");
                }
                oITreeNode = new OITreeNode();
                hashtable.put(n2, oITreeNode);
            }
            if (n + 1 == oID.value.length) {
                if (this.debug) {
                    if (oITreeNode.oi == null) {
                        System.out.println("InsertOINode: inserting value " + mibObjectIdentifierValue.getValue() + " in node");
                    } else {
                        System.out.println("InsertOINode: replacing value " + mibObjectIdentifierValue.getValue() + " in node");
                    }
                }
                oITreeNode.oi = mibObjectIdentifierValue;
                oITreeNode.lastComponent = n2;
                return;
            }
            if (oITreeNode.children == null) {
                oITreeNode.children = new Hashtable();
            }
            this.insertOINode(oID, n + 1, mibObjectIdentifierValue, oITreeNode.children);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    class OITreeNode {
        public MibObjectIdentifierValue oi;
        public Hashtable children;
        public int lastComponent;

        public String toString() {
            if (this.oi != null) {
                if (this.children != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(this.oi.toString());
                    stringBuffer.append('(');
                    Enumeration enumeration = this.children.keys();
                    while (enumeration.hasMoreElements()) {
                        Integer n = (Integer)enumeration.nextElement();
                        stringBuffer.append(n);
                    }
                    stringBuffer.append(')');
                    return stringBuffer.toString();
                }
                return this.oi.toString();
            }
            return "null";
        }

        OITreeNode() {
            MibMetadata.this = MibMetadata.this;
        }
    }
}

